import matplotlib.pyplot as plt
from matplotlib import rcParams

rcParams['font.sans-serif'] = ['WenQuanYi Zen Hei']

rcParams['axes.unicode_minus'] = False

k_values = [2, 3, 4, 5, 10, 13, 16,
            20, 23, 26, 30, 35, 40, 50,
            60, 80, 100, 200, 300, 400,
            600, 700, 800, 900, 980, 1000]
runtimes = [0.0735, 0.0754, 0.0635, 0.0817, 0.0728, 0.0360, 0.0605,
            0.0453, 0.0311, 0.0540, 0.0295, 0.0245, 0.0191, 0.0196,
            0.0215, 0.0263, 0.0271, 0.0517, 0.0631, 0.0864,
            0.0675, 0.2509, 0.2851, 0.2490, 0.2355, 0.1730]
iterations = [2, 3, 4, 8, 8, 8, 13,
              9, 9, 13, 8, 7, 6, 6,
              6, 6, 6, 7, 4, 5,
              3, 5, 5, 5, 3, 2]

fig, ax1 = plt.subplots(figsize=(8, 6))

# plot runtime on left y‐axis
ln1 = ax1.plot(k_values, runtimes, label='Runtime (s)')
ax1.set_xlabel('k value')
ax1.set_ylabel('Runtime (s)')

ax2 = ax1.twinx()
ln2 = ax2.plot(k_values, iterations, label='Iterations', linestyle='--')
ax2.set_ylabel('Iterations')

lines = ln1 + ln2
labels = [l.get_label() for l in lines]
ax1.legend(lines, labels, loc='best')

plt.title('Effect of k on Runtime and Number of Iterations')
plt.show()
