import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt

df = pd.read_csv('/home/linux/dm/lab1/data_file/processed_student_data.csv')

# habits_and_performance = df[['gender','study_hours_per_day', 'social_media_hours','netflix_hours','sleep_hours', 
#                              'part_time_job','attendance_percentage','exercise_frequency','parental_education_level' ,
#                              'mental_health_rating','extracurricular_participation','exam_score']]

habits_and_performance = df[['gender','study_hours_per_day_normalized', 'social_media_hours_normalized','netflix_hours_normalized','sleep_hours', 
                             'part_time_job','attendance_percentage_normalized','exercise_frequency','parental_education_level' ,
                             'mental_health_rating_normalized','extracurricular_participation','exam_score']]

correlation_matrix = habits_and_performance.corr()

plt.figure(figsize=(8, 6))
sns.heatmap(correlation_matrix, annot=True, cmap='coolwarm', vmin=-1, vmax=1, center=0, fmt='.2f')

plt.title('Correlation Heatmap between Student Habits and Academic Performance')

plt.show()
