
import seaborn as sns
import matplotlib.pyplot as plt
import pandas as pd

df = pd.read_csv('/home/linux/dm/lab1/data_file/processed_student_data.csv')

sleep_gender_count = df.groupby(['original_gender', 'sleep_hours_category_numeric']).size().reset_index(name='count')

plt.figure(figsize=(10, 6))
sns.barplot(x='sleep_hours_category_numeric', y='count', hue='original_gender', data=sleep_gender_count)

plt.title('Number of People in Each Sleep Category by Gender')
plt.xlabel('Sleep Hours Category')
plt.ylabel('Number of People')

plt.show()